/*******************************************************************************
*                         USB4ALLAPI Library Version 1.0                       *
*******************************************************************************/
#ifndef _DRIVERLIBUSBWIN32_H_
#define _DRIVERLIBUSBWIN32_H_

using namespace std;
#include <map>
#include <usb.h>
#include "iDriverLayer.h"
#include "iPlatformLayer.h"
#include "U4ADefines.h"
#include "Log.h"

class DriverLibUsbWin32 : public iDriverLayer {
    private:
        map<int,itemBoard> boards;
        int explenrecv;
        int pid;
        int vid;
        void findU4ABoards();
        struct usb_dev_handle* getInstance(int);
        int unBuildBoardPart(int);
        int unBuildDscPart(int);
        iPlatformLayer * pl;
        log *l;
    public:
        DriverLibUsbWin32();
        ~DriverLibUsbWin32();
        int* getU4ABoards(int&);
        int qtyDsc(int);
        dscEndpoint* getEndpointDsc(int, int);
        int openIn(int, int, int);
        int openOut(int, int, int);
        bool close(int);
        bool sendInt(int, char *, int, int);
        bool sendCtrl(int, char*, int, int);
        bool sendIso(int, char*, int, int);
        bool sendBulk(int, char*, int, int);
        char* receiveInt(int, int&, bool&, int);
        char* receiveCtrl(int, int&, bool&, int);
        char* receiveIso(int, int&, bool&, int);
        char* receiveBulk(int, int&, bool&, int);
};

#endif
